; This file is part of the Resolution ][ library
;
; Copyright (c) 2000 Arthur Jerijian
; 
; Permission is hereby granted, free of charge, to any person obtaining
; a copy of this software and associated documentation files
; (the "Software"), to deal in the Software without restriction, including
; without limitation the rights to use, copy, modify, merge, publish,
; distribute, sublicense, and/or sell copies of the Software, and to permit
; persons to whom the Software is furnished to do so, subject to the
; following conditions:
; 
; The above copyright notice and this permission notice shall be included
; in all copies or substantial portions of the Software.
; 
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
; OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
; THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; DEALINGS IN THE SOFTWARE.

; ======================================================================
;
; CONSTANTS AND DEFINITIONS

; Number of bits in a 16-bit word
#define bits_per_word #$10

; Number of bits in a byte
#define bits_per_byte #$08

; Start address of dynamic zero page data
#define zp $FA

; Start address of program
#define program_start $6100

; Start address of dynamic data
#define write_area $6000

; ======================================================================
;
; HARDWARE SOFT SWITCHES AND ACCESS LOCATIONS

; Soft switches
#define	ss_80_store	$C001
#define	ss_80_col	$C00D
#define	ss_graphics	$C050
#define	ss_fullscreen	$C052
#define ss_main_page	$C054
#define ss_aux_page	$C055
#define	ss_hi_res	$C057
#define ss_no_an3	$C05E

; Double-high-resolution image buffer
#define image_buffer	$2000
#define image_buffer_lo	#$00
#define image_buffer_hi	#$20

; ======================================================================
;
; VARIABLE SPACE
;
; For more information on these parameters, refer to the appropriate
; source file.

; Buffer pointer
#define buffer_ptr	zp

; Screen filling
#define fill_byte	write_area
					; One byte
#define	fill_offset	write_area + 1
					; One byte

; Division
#define	divisor		write_area + 2
					; One byte
#define	quotient	write_area + 3
					; One byte
#define remainder	write_area + 4
					; One byte

; Pixel coordinates
#define x_coord		write_area + 5
					; Two bytes
#define y_coord		write_area + 7
					; One byte

; Offset parameters
#define x_coord_work	write_area + 8
					; Two bytes
#define x_offset 	write_area + 10
					; One byte
#define x_page		write_area + 11
					; One byte
#define x_bit		write_area + 12
					; One byte
#define y_offset 	write_area + 13
					; Two bytes

; Color values
#define color_work	write_area + 15
					; One byte
#define use_color	write_area + 16
					; One byte
#define	pen_color	write_area + 17
					; One byte
#define read_color	write_area + 18
					; One byte

; Color calculation parameters
#define	color_draw_mask		write_area + 19
					; Two bytes
#define	color_erase_mask	write_area + 21
					; Two bytes

; Line-drawing coordinates
#define line_x_start	write_area + 23
					; Two bytes
#define line_y_start	write_area + 25
					; One byte
#define line_x_end	write_area + 26
					; Two bytes
#define line_y_end	write_area + 28
					; One byte

; Line-drawing parameters
#define line_d		write_area + 29
					; Two bytes
#define line_d_work	write_area + 31
					; Two bytes
#define line_ax		write_area + 33
					; Two bytes
#define line_ay		write_area + 35
					; Two bytes
#define line_sx		write_area + 37
					; One byte
#define line_sy		write_area + 38
					; One byte

